/****************************************************************************

	HoneyRadio2
		Copyright(C) 2012 Mr.Honey

****************************************************************************/
#ifndef __FTP_H
#define __FTP_H

/*********************************************************************
 * Function:        void FTPInit(void)
 *
 * PreCondition:    TCP module is already initialized.
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Initializes internal variables of Telnet
 *
 * Note:
 ********************************************************************/
void FTPInit(void);


/*********************************************************************
 * Function:        void FTPServer(void)
 *
 * PreCondition:    FTPInit() must already be called.
 *
 * Input:           None
 *
 * Output:          Opened Telnet connections are served.
 *
 * Side Effects:    None
 *
 * Overview:
 *
 * Note:            This function acts as a task (similar to one in
 *                  RTOS).  This function performs its task in
 *                  co-operative manner.  Main application must call
 *                  this function repeatdly to ensure all open
 *                  or new connections are served on time.
 ********************************************************************/
BOOL FTPServer(void);


//////////////////////////////////////////////////////////////////////
//FTP Application interface

#define MAX_PATH	128
#define FTPH		void*

#define FTP_FREAD	0
#define FTP_FCREATE	1
#define FTP_FAPPEND	2

extern BOOL FtpVerify(char* pUser, char* Pass);
extern BOOL FtpChDir(char* pDir);
extern BOOL FtpSetType(char* pType);
extern FTPH FtpOpen(char* pFile, int nType);
extern void FtpClose(FTPH hFile);
extern BOOL FtpRead(FTPH hFile, BYTE* pBuf, UINT nSize, UINT* pSize);
extern BOOL FtpWrite(FTPH hFile, BYTE* pBuf, UINT nSize);
extern FTPH FtpOpenList(char* pPath, BOOL fDetail);
extern int FtpGetNext(FTPH hList, char* pBuf, UINT* pSize);
extern BOOL FtpRename(char* pOld, char* pNew);
extern BOOL FtpDelete(char* pPath);
extern BOOL FtpMkDir(char* pDir);
extern char* FtpGetCur(char* pPath);

#endif
